function Driving_condition(NI_daq_session,T,fm,PZT_num)

% This function activate both levitation and lateral resonance frequency 
% for a period of time T. The variable fm can be only equal to 1,2 ,3,4 or
% 5 that corresponds to the order of the lateral frequncy. The NI box is 
% controlled by sending a vector with 4 bits for frequency and 2 bits for PZT, the first bit for the 
% levitation frequncy activation and the next 3 for the lateral one. The last
% two bits represnts the activated PZT number. 

% The frequency table : first row for the first lateral frequnecy and so on..
Freq_Table=[1 0 0;0 1 0;1 1 0;0 0 1;1 0 1];
L1=Freq_Table(fm,1);% first bit (LSB)
L2=Freq_Table(fm,2);% second bit 
L3=Freq_Table(fm,3);% third bit (MSB)

% The PZT table : first,second and third rows for the first,second and both
% PZTs respectively.
PZT_Table=[1 0;0 1;1 1];
PZT1=PZT_Table(PZT_num,1);% first bit (LSB)
PZT2=PZT_Table(PZT_num,2);% second bit (MSB)

% Activation of NI ports 
outputSingleScan(NI_daq_session,[1 L1 L2 L3 PZT1 PZT2]);% send Data signals to ports with status one.
pause(T); % activation time.
outputSingleScan(NI_daq_session,[1 0 0 0 1 1]);% remove frequency data signals from port lines ( with status zero )
end

